﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private Const HORZ_TILES = 4
    Private Const VERT_TILES = 4
    Private Const _MARGIN = 2

    Private appService As PhoneApplicationService = PhoneApplicationService.Current
    Private photoChooser As New PhotoChooserTask()
    Private rand As New Random()

    Private tileImages(VERT_TILES - 1, HORZ_TILES - 1) As Image
    Private haveValidTileImages As Boolean
    Private emptyRow, emptyCol As Integer
    Private scrambleCountdown As Integer


    Public Sub New()
        InitializeComponent()

        For col = 0 To HORZ_TILES - 1
            Dim coldef As New ColumnDefinition()
            coldef.Width = New GridLength(1, GridUnitType.Star)
            playGrid.ColumnDefinitions.Add(coldef)
        Next col

        For row = 0 To VERT_TILES - 1
            Dim rowdef As New RowDefinition()
            rowdef.Height = New GridLength(1, GridUnitType.Star)
            playGrid.RowDefinitions.Add(rowdef)
        Next row

        appbarScrambleButton = TryCast(Me.ApplicationBar.Buttons(1), 
            ApplicationBarIconButton)

        AddHandler photoChooser.Completed, AddressOf OnPhotoChooserCompleted
    End Sub


    Private Sub OnLoadClick(ByVal sender As Object, ByVal args As EventArgs)
        Dim tileSize = CInt(Math.Min(ContentPanel.ActualWidth / HORZ_TILES,
                                     ContentPanel.ActualHeight / VERT_TILES)) - 2 * _MARGIN

        photoChooser.PixelWidth = tileSize * HORZ_TILES
        photoChooser.PixelHeight = tileSize * VERT_TILES
        photoChooser.Show()
    End Sub


    Private Sub OnScrambleClick(ByVal sender As Object, ByVal args As EventArgs)
        scrambleCountdown = 10 * VERT_TILES * HORZ_TILES
        scrambleButton.IsEnabled = False
        appbarScrambleButton.IsEnabled = False
        AddHandler CompositionTarget.Rendering, AddressOf OnCompositionTargetRendering
    End Sub


    Private Sub OnCompositionTargetRendering(ByVal sender As Object, ByVal args As EventArgs)
        MoveTile(tileImages(emptyRow, rand.Next(HORZ_TILES)))
        MoveTile(tileImages(rand.Next(VERT_TILES), emptyCol))
        scrambleCountdown -= 1
        If scrambleCountdown = 0 Then
            RemoveHandler CompositionTarget.Rendering, AddressOf OnCompositionTargetRendering
            scrambleButton.IsEnabled = True
            appbarScrambleButton.IsEnabled = True
        End If
    End Sub


    Private Sub OnPhotoChooserCompleted(ByVal sender As Object, ByVal args As PhotoResult)
        If args.Error Is Nothing AndAlso args.ChosenPhoto IsNot Nothing Then
            Dim bitmapImage As New BitmapImage()
            bitmapImage.SetSource(args.ChosenPhoto)
            Dim writeableBitmap As New WriteableBitmap(bitmapImage)
            Dim tileSize = writeableBitmap.PixelWidth \ HORZ_TILES

            emptyCol = HORZ_TILES - 1
            emptyRow = VERT_TILES - 1

            For row = 0 To VERT_TILES - 1
                For col = 0 To HORZ_TILES - 1
                    If row <> emptyRow OrElse col <> emptyCol Then
                        Dim tile As New WriteableBitmap(tileSize, tileSize)

                        For y = 0 To tileSize - 1
                            For x = 0 To tileSize - 1
                                Dim yBit = row * tileSize + y
                                Dim xBit = col * tileSize + x

                                tile.Pixels(y * tileSize + x) =
                                    writeableBitmap.Pixels(yBit *
                                                           writeableBitmap.PixelWidth +
                                                           xBit)
                            Next x
                        Next y
                        GenerateImageTile(tile, row, col)
                    End If
                Next col
            Next row

            haveValidTileImages = True
            scrambleButton.IsEnabled = True
            appbarScrambleButton.IsEnabled = True
        End If
    End Sub


    Private Sub GenerateImageTile(ByVal tile As BitmapSource,
                                  ByVal row As Integer, ByVal col As Integer)
        Dim img As New Image()
        img.Stretch = Stretch.None
        img.Source = tile
        img.Margin = New Thickness(_MARGIN)
        tileImages(row, col) = img

        Grid.SetRow(img, row)
        Grid.SetColumn(img, col)
        playGrid.Children.Add(img)
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        If TypeOf args.OriginalSource Is Image Then
            Dim img = TryCast(args.OriginalSource, Image)
            MoveTile(img)
            args.Complete()
            args.Handled = True
        End If
        MyBase.OnManipulationStarted(args)
    End Sub


    Private Sub MoveTile(ByVal img As Image)
        Dim touchedRow = -1, touchedCol = -1

        For y = 0 To VERT_TILES - 1
            For x = 0 To HORZ_TILES - 1
                If tileImages(y, x) Is img Then
                    touchedRow = y
                    touchedCol = x
                End If
            Next x
        Next y

        If touchedRow = emptyRow Then
            Dim sign = Math.Sign(touchedCol - emptyCol)

            Dim x = emptyCol
            Do While x <> touchedCol
                tileImages(touchedRow, x) = tileImages(touchedRow, x + sign)
                Grid.SetColumn(tileImages(touchedRow, x), x)
                x += sign
            Loop
            tileImages(touchedRow, touchedCol) = Nothing
            emptyCol = touchedCol
        ElseIf touchedCol = emptyCol Then
            Dim sign = Math.Sign(touchedRow - emptyRow)

            Dim y = emptyRow
            Do While y <> touchedRow
                tileImages(y, touchedCol) = tileImages(y + sign, touchedCol)
                Grid.SetRow(tileImages(y, touchedCol), y)
                y += sign
            Loop
            tileImages(touchedRow, touchedCol) = Nothing
            emptyRow = touchedRow
        End If
    End Sub


    Protected Overrides Sub OnNavigatedFrom(ByVal args As NavigationEventArgs)
        appService.State("haveValidTileImages") = haveValidTileImages

        If haveValidTileImages Then
            appService.State("emptyRow") = emptyRow
            appService.State("emptyCol") = emptyCol

            For row = 0 To VERT_TILES - 1
                For col = 0 To HORZ_TILES - 1
                    If col <> emptyCol OrElse row <> emptyRow Then
                        Dim tile = TryCast(tileImages(row, col).Source, WriteableBitmap)
                        Dim stream As New MemoryStream()
                        tile.SaveJpeg(stream, tile.PixelWidth, tile.PixelHeight, 0, 75)
                        appService.State(TileKey(row, col)) = stream.GetBuffer()
                    End If
                Next col
            Next row
        End If
        MyBase.OnNavigatedFrom(args)
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        Dim objHaveValidTileImages = Nothing

        If appService.State.TryGetValue("haveValidTileImages",
                                        objHaveValidTileImages) AndAlso
                                    CBool(objHaveValidTileImages) Then
            emptyRow = CInt(appService.State("emptyRow"))
            emptyCol = CInt(appService.State("emptyCol"))

            For row = 0 To VERT_TILES - 1
                For col = 0 To HORZ_TILES - 1
                    If col <> emptyCol OrElse row <> emptyRow Then
                        Dim buffer() = CType(appService.State(TileKey(row, col)), Byte())
                        Dim stream As New MemoryStream(buffer)
                        Dim bitmapImage As New BitmapImage()
                        bitmapImage.SetSource(stream)
                        Dim tile As New WriteableBitmap(bitmapImage)
                        GenerateImageTile(tile, row, col)
                    End If
                Next col
            Next row

            haveValidTileImages = True
            appbarScrambleButton.IsEnabled = True
        End If

        MyBase.OnNavigatedTo(args)
    End Sub


    Private Function TileKey(ByVal row As Integer, ByVal col As Integer) As String
        Return String.Format("tile {0} {1}", row, col)
    End Function
End Class